Write-Host "====    Fiskaltrust Middleware Export Version 0.0.3    ===="
Write-Host " - Der DSFinV-K Export kann auch bei kurzen Zeitraeumen"
Write-Host "   20 Minuten oder laenger dauern."
Write-Host " - Der TSE Export aus TSE kann je nach Umfang mehrere"
Write-host "   Stunden dauern und enthaelt nur dann Daten wenn der"
Write-Host "   TAR Export in der Middleware deaktiviert ist."
Write-Host "   Der Export aus TSE sollte nur nach Ruecksprache"
Write-Host "   ausgefuerth werden."
Write-Host " "
Write-Host "Der Queue Port muss nur in Sonderfaellen bei bestimmten" 
Write-Host "Installationsvoraussetzungen geaendert werden."
Write-Host "Im Zweifel leer lassen!"
Write-Host "Queue Port aendern?" -BackgroundColor blue
$inQueuePort = Read-Host "leer wenn nein, sonst Port Nummer"
if ($inQueuePort -ne "") {
  $baseUrl = -join('http://localhost:', $inQueuePort, '/fiskaltrust/json/v0/Journal?type=')
} else {
  $baseUrl = 'http://localhost:1500/fiskaltrust/json/v0/Journal?type='
}
Write-Host " "
Write-Host "Welcher Export soll erstellt werden?" -BackgroundColor blue
$inExportType = Read-Host "
1. DSFinV-K
2. TSE .tar (aus Middleware)
3. TSE .tar (aus TSE)
0. Verlassen

1 2 oder 3 eingeben und mit Enter bestaetigen
"
switch ($inExportType)
{
  1 {
      Write-Host "DSFinV-K export gewaehlt"
      $outExportType = "DSFinV-K"
      $exportType = '4919338167972134914'
      $filename = -join('-o "DSFinV-K_', $(Get-Date -Format "yyyy-MM-dd_HH.mm") ,'.zip"')
    }
  2 {
      Write-Host ".tar Middleware export gewaehlt"
      $outExportType = ".tar Middleware"
      $exportType = '4919338167972134915'
      $filename = -join('-o "TSE_', $(Get-Date -Format "yyyy-MM-dd_HH.mm") ,'.tar"')
    }
  3 {
    Write-Host ".tar TSE export gewaehlt"
      $outExportType = ".tar TSE"
      $exportType = '4919338167972134913'
      $filename = -join('-o "TSE_', $(Get-Date -Format "yyyy-MM-dd_HH.mm") ,'.tar"')
    }
  0 {
    Write-Host "Beende Programm."
    timeout 10
    exit
  }
  Default {
    Write-Host "Export Typ nicht gefunden. Beende Programm." -BackgroundColor red
    timeout 20
    exit
  }
}
$startDate = Read-Host "Startdatum (Format: JJJJ-MM-TT). 'leer' wenn alles"
if ($startDate -ne "") {
  $endDate = Read-Host "Enddatum (Format: JJJJ-MM-TT)."
}


if ($startDate -ne "" -and $endDate -ne "") {
  $startDate = $startDate + " 00:00:00"
  $endDate = $endDate + " 23:59:59"
  if ($startDate -gt $endDate) {
    Write-Host "start Datum liegt vor end Datum" -BackgroundColor red
    timeout 60
    exit
  }
  $outExportDate = $startDate + " - " + $endDate
  $url = $baseUrl + $exportType + "&from=" + (Get-Date $startDate).Ticks + "&to=" + (Get-Date $endDate).Ticks
}
else {
  $outExportDate = "alle vorhandenen Daten"
  $url = $baseUrl + $exportType
}

Write-Host "erstelle" $outExportType "Export. Zeitraum:" $outExportDate -BackgroundColor blue
Write-Host "Der Export kann je nach Zeitraum und Typ 20 Mintuten und mehr benoetigen." -BackgroundColor blue
$curlResult = Start-Process -FilePath "curl.exe" -ArgumentList @('--location', '--request POST', '-d ""', $url, $filename) -Wait -NoNewWindow -PassThru
if ($curlResult.ExitCode -ne 0){
  Write-Host "Fehler beim erstellen des Exports" -BackgroundColor red
}
else {
  Write-Host "Export im Script Ordner erstellt." -BackgroundColor green -ForegroundColor Black
}

timeout 60
exit